<?php

$servername = "localhost"; 
$username = "calank_Guest"; 
$password = "WTBH83LmnNFg";
$dbname = "calank_Client_Support_System";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: ". $conn->connect_error);
}
else{
    echo "Connected succesfully";
}

// The total number of tickets which are in the system
$total_tickets_sql = "SELECT COUNT(*) AS total FROM tickets";
$total_tickets_result = $conn->query($total_tickets_sql);
$total_tickets = $total_tickets_result->fetch_assoc()['total'];

// Counts the tickets by the status such as open or closed
$status_sql = "SELECT status_type, COUNT(*) AS count FROM tickets GROUP BY status_type";
$status_result=$conn->query($status_sql);

// Calculate the average ressolution time in hours from the progress logs
$avg_resolution_sql = "
SELECT AVG(TIMESTAMPDIFF(HOUR, p.created_at, p.closed_at)) AS avg_hours FROM progress p
WHERE p.closed_at IS NOT NULL
";

$avg_result = $conn->query($avg_resolution_sql);
$avg_hours = round($avg_result->fetch_assoc() ['avg_hours']);

// Counts the most common type of issues
$category_sql = "SELECT category, COUNT(*) AS total FROM tickets GROUP BY category ORDER BY total DESC";
$category_result = $conn->query($category_sql);

// how many tickets each agent has handled
$agent_sql = "SELECT a.name, COUNT (t.ticket_id) AS total_tickets
                FROM agents a
                LEFT join tickets t ON a.agent_id = t.agent_id
                GROUP BY a.agent_id
                GROUP BY a.agent_id
                ORDER BY total_tickets DESC";

$agent_result = $conn->query($agent_sql);

$conn->close();
?>

<!DOCTYPE html>
<html> 
<head>
    <title> Dashboard Report</title>
</head>
<body>
    <h2> Dashboard Report</h2>
    
    <a href="existing_solutions.php" target="blank" style="text-decoration: none; color: blue;">
             Search for Exisitng Solutions
             
         </a><br>
         
         <a href="progress_log.php" target="blank" style="text-decoration: none; color; blue;">
             Ticket Progress Log
         </a><br>
         
         <a href="followupqueries.php" target="blank" style="text-decoration: none; color; blue">
             Follow Up Queries
         </a><br>
         
        <a href="support_form.php" target="blank" styl="text-decoration: none; color: blue;">
         Support Form
         
         </a>
    
    <p><strong>Total Amount Of Tickets:</strong> <?= $total_tickets ?></p>
    <p><strong> Average Resolution Time: </strong> <?= $avg_hours ?> hours</p>
    
    <h3>Status Overview</h3>
    <ul>
        <?php while ($row = $status_result->fetch_assoc()): ?>
            <li><?= ucfirst($row['status_type']) ?>: <?= $row['count'] ?></li>
            <?php endwhile; ?>
    </ul>
    
    <h3>Top Issues By Category</h3>
    <ul> 
        <?php while ($row = $category_result->fetch_assoc()): ?>
        <li><?= $row['category'] ?> (<?= $row['total'] ?> Tickets)</li>

        <?php endwhile; ?>
    </ul>
    
        <h3>Agent Performance</h3>
    <ul>
        <?php while ($row = $agent_result->fetch_assoc()): ?>
            <li><?= $row ['name'] ?> - <?=$row['total_tickets'] ?>Tickets Handled</li>
            <?php endwhile; ?>
    </ul>
    
    
</body>
</html>
